RequireScript("enemiesnew.js"); // <- Enemy info

var bg = LoadImage("background_grass1.png")
var window = LoadWindowStyle("projectpheonixstyle1.rws")
var font = LoadFont("arial.rfn")
var BattleEnemies = new Array();
var CurrentEnemy = 0; 
var CurrentPlayer = 0;
var Items = new Array();
var Spells = new Array();
var sh = GetScreenHeight();
var sw = GetScreenWidth();

function addEnemy(number)
{
	BattleEnemies.push(enemies[number]);
}

function enemyAdd()
{
	addEnemy(0);
}

function drawPlayerWindow(x,y,w,h)
{
	window.drawWindow(x,y,w,h);
	for (var i = 0; i < players.length; ++i)
	{
		players[i].portrait.blit((x+1)+i*128,y+4);
		font.drawText((x+33)+i*128,y+4,players[i].name);
		font.drawText((x+33)+i*128,y+24,"HP: " +players[i].hp);
		font.drawText((x+33)+i*128,y+44,"MP: " +players[i].mp);
	}
}

function createEnemies()
{
	while (BattleEnemies.length > 0)
	{
		bg.blit(0,0);
		drawPlayerWindow(3,sh-67,sw-6,64);
		FlipScreen();
	}
}

function drawEnemies()
{
    for (var i = 0; i < BattleEnemies.length; ++i)
    {
        try {
          BattleEnemies[i].pic.blit((sw/2+((BattleEnemies.length*64)/2))+i*65,sh/2-64)
        }
        catch(e) { throw (e + "\nmy_object was type: " + (typeof BattleEnemies[i].pic)); }
    }
}

function setEnemies()
{
	while(BattleEnemies.length > 0)
	{
		drawEnemies();
	}
}

var pixilmovement = 0;
var pixilgap = 3;
var direction = "up"

function Delay(milliseconds)
{
  var start = GetTime();
  while (start + milliseconds > GetTime()) {
  }
}

function InfoWindow(text,x,y,w,h)
{
  if (!IsKeyPressed(KEY_ENTER)) {
    if (pixilmovement < pixilgap && direction == "up")
    {
      Delay(80);
      ++pixilmovement;
      if (pixilmovement == pixilgap)
      {
        direction = "down";
      }
      return windowstuff(text,x,y-pixilmovement,w,h);
    }
    if (pixilmovement <= pixilgap && direction == "down")
    {
      Delay(80);
      --pixilmovement;
      if (pixilmovement == 0)
      {
        direction = "up";
      }
      return windowstuff(text,x,y-pixilgap-pixilmovement,w,h);
    }
  }
}

function windowstuff(text,x,y,w,h)
{
  window.drawWindow(x,y,w,h);
  font.drawText(x+6,y+6,text);
}

function TextMe(text,x,y,w,h)
{
  var screen = GrabImage(0,0,sw,sh);
  
  while (!IsKeyPressed(KEY_ENTER))
  {
    screen.blit(0,0);
    InfoWindow(text,x,y,w,h);
    FlipScreen();
  }
}

var selector = LoadWindowStyle("style2.rws");
var attack = false;

function drawPlayerSelector()
{
	if (attack == false)
	{
		selector.drawWindow(6+CurrentPlayer*128,sh-64,122,58);
	}
}

function drawEnemySelector()
{
	if (attack == true)
	{
		selector.drawWindow((sw/2-((BattleEnemies.length*64)/2))+CurrentEnemy*64,sh/2-64,64,64)
	}
}

var battlemenu = false;

function HandleInput()
{
  if (attack == false)
  {
    if (IsKeyPressed(KEY_LEFT) == true && CurrentPlayer > 0)
    {
      Delay(250)
      CurrentPlayer--;
    }
    if (IsKeyPressed(KEY_RIGHT) == true && CurrentPlayer < players.length-1)
    {
      Delay(250)
      CurrentPlayer++;
    }
    if (IsKeyPressed(KEY_ENTER) == true)
    {
      battlemenu = true;
    }
  }
  else
  {
    if (IsKeyPressed(KEY_LEFT) == true && CurrentEnemy > 0)
    {
      Delay(250)
      CurrentEnemy--;
    }
    if (IsKeyPressed(KEY_RIGHT) == true && CurrentEnemy < BattleEnemies.length-1)
    {
      Delay(250)
      CurrentEnemy++;
    }
    if (IsKeyPressed(KEY_ENTER) == true)
    {
      DoBattle(CurrentEnemy);
    }
  }
}

var options = new Array("Attack","Items","Spells","Flee","Back");
var CurrentOption = 0;
var Gray = CreateColor(175,175,175);

function BattleMenu()
{
  window.drawWindow(sw-67,sh-67,62,64);
  Rectangle(sw-67,sh-64+CurrentOption*12,62,12,Gray);
  for (var i = 0; i < options.length; ++i)
  {
    font.drawText(sw-67,sh-67+i*12,options[i]);
  }
  if (IsKeyPressed(KEY_DOWN) == true && CurrentOption < options.length-1)
  {
    Delay(150);
    CurrentOption++;
  }
  if (IsKeyPressed(KEY_UP) == true && CurrentOption > 0)
  {
    Delay(150);
    CurrentOption--;
  }
  if (IsKeyPressed(KEY_ENTER) == true)
  {
    if (CurrentOption == 0)
    {
      Delay(150);
      battlemenu = false;
      attack = true;
    }
    if (CurrentOption == 1)
    {
      Delay(150);
      battlemenu = false;
    }
    if (CurrentOption == 2)
    {
      Delay(150);
      battlemenu = false;
    }
    if (CurrentOption == 3)
    {
      battlemenu = false;
      var i = Math.floor(Math.random()*10);
      if (i > 2)
      {
        Delay(250);
        TextMe("You ran away from the enemy!",3,7,sw-6,32);
        Exit();
      }
      if (i < 2)
      {
        Delay(250);
        TextMe("Your enemy has blocked your path!",3,7,sw-6,32);
        enemyattack = true;
      }
    }
    if (CurrentOption == 4)
    {
      Delay(150);
      battlemenu = false;
    }
  }
}

var CurrentImage = 0;

function DoBattle(enemy)
{
  Delay(150);
  BattleEnemies[enemy].hp -= players[CurrentPlayer].atk
}

function AnimateAttack(spriteset,enemy)
{
  var screen = GrabImage(0,0,sw,sh);
  var images = spriteset.images;
  do
  {
    screen.blit(0,0);
    images[CurrentImage].blit((sw/2-((BattleEnemies.length*64)/2))+CurrentEnemy*64,sh/2-64);
    Delay(150);
    CurrentImage++;
    if (CurrentImage == 6)
    {
      attack = false;
      CurrentImage = 0;
      break;
    }
    FlipScreen();
  }
  while (CurrentImage >= 0)
}

var enemyattack = false;
function EnemyAttack()
{
  var attackwho = Math.floor(Math.random()*10);
  var whoattack = Math.floor(Math.random()*10);
  
  if (whoattack < BattleEnemies.length && attackwho < players.length)
  {
    enemyattack = false;
    Delay(250);
    TextMe(BattleEnemies[whoattack].name + " has attacked " + players[attackwho].name + " for " +  BattleEnemies[whoattack].atk + " points of damage.",3,6,sw-6,32);
    players[attackwho].hp -= BattleEnemies[whoattack].atk;
    Delay(250);
  }
  else
  {
    EnemyAttack();
  }
}

function StartBattle()
{
  while (IsKeyPressed(KEY_ESCAPE) != true)
  {
    bg.blit(0,0);
    drawPlayerWindow(3,sh-67,sw-6,64)
    drawPlayerSelector();
    drawEnemies();
    drawEnemySelector();
    if (battlemenu == true)
    {
      BattleMenu();
    }
    if (enemyattack == true)
    {
      EnemyAttack();
    }
    if (battlemenu == false && enemyattack == false)
    {
      HandleInput();
    }
    FlipScreen()
    for (var i = 0; i < BattleEnemies.length; i++)
    {
      if (BattleEnemies[CurrentEnemy].hp <= 0)
      {
        TextMe("The enemy has died!",3,6,sw-6,32);
        BattleEnemies.splice(CurrentEnemy,1);
        CurreneEnemy = 0;
        Delay(200);
      }
    }
    for (var i = 0; i < players.length;i++)
    {
      if (players[i].hp <= 0)
      {
        TextMe("You have died.",3,6,sw-6,32);
        players.splice(CurrentPlayer,1);
      }
    }
    if (players.length == 0)
    {
      TextMe("You have died.");
      Exit();
    }
    if (BattleEnemies.length == 0)
    {
      TextMe("You have won the battle!",3,6,sw-6,32);
      Exit();
    }
  }
}